/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth.util;

import com.ibm.hwmca.fw.managed.HwmcaParentObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.ShortObjectIdManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.AbstractNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.config.ResourcesNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeResourceMONode;
import com.ibm.hwmca.ui.bonsai.earth.util.NodeRetrieverInterface;
import com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet;
import com.ibm.hwmca.ui.bonsai.util.IdUtilities;
import com.ibm.hwmca.ui.bonsai.util.SortedList;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class MOMNodeRetriever
implements NodeRetrieverInterface {
    public List getNodes(BonsaiTreeNode parent, AbstractNodeConfigBean configBean, Map params) throws BonsaiConfigException {
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        Iterator iterator = mom.getInventory(IdUtilities.getClassIds((String)params.get("class"))).iterator();
        SortedList nodes = new SortedList(BonsaiTreeResourceMONode.getComparator());
        HwmcaParentObject obj = null;
        BonsaiTreeResourceMONode node = null;
        String properties = null;
        while (iterator.hasNext()) {
            obj = (HwmcaParentObject)iterator.next();
            this.waitUntilFound(obj);
            node = new BonsaiTreeResourceMONode((ResourcesNodeConfigBean)configBean, obj, parent);
            properties = (String)params.get("listener_properties");
            if (properties != null) {
                this.registerPropertyChangeListener(node, obj, properties);
            }
            if ((properties = (String)params.get("column_properties")) != null) {
                this.setColumnProperties(node, properties);
            }
            nodes.add(node);
        }
        return nodes;
    }

    public List getNodesFromParent(BonsaiTreeNode parent, AbstractNodeConfigBean configBean, Map params) throws BonsaiConfigException {
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        HwmcaParentObject obj = (HwmcaParentObject)mom.get(UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager().getObjectId(((BonsaiTreeResourceMONode)parent).getShortId()));
        SortedList nodes = new SortedList(BonsaiTreeResourceMONode.getComparator());
        HwmcaParentObject child = null;
        BonsaiTreeResourceMONode node = null;
        String properties = null;
        Iterator children = obj.getChildren().iterator();
        while (children.hasNext()) {
            child = (HwmcaParentObject)mom.get((ObjectId)children.next());
            if (child == null) continue;
            this.waitUntilFound(child);
            node = new BonsaiTreeResourceMONode((ResourcesNodeConfigBean)configBean, child, parent);
            properties = (String)params.get("listener_properties");
            if (properties != null) {
                this.registerPropertyChangeListener(node, child, properties);
            }
            if ((properties = (String)params.get("column_properties")) != null) {
                this.setColumnProperties(node, properties);
            }
            nodes.add(node);
        }
        return nodes;
    }

    protected void setColumnProperties(BonsaiTreeResourceMONode node, String properties) throws BonsaiConfigException {
        StringTokenizer propertyTokens = new StringTokenizer(properties, ";");
        ArrayList<String> propertyKeys = new ArrayList<String>(propertyTokens.countTokens());
        while (propertyTokens.hasMoreTokens()) {
            propertyKeys.add(this.getDeclaredStringField(propertyTokens.nextToken()));
        }
        node.setColumnTypes(propertyKeys);
    }

    protected void registerPropertyChangeListener(PropertyChangeListener listener, HwmcaParentObject registeree, String properties) throws BonsaiConfigException {
        StringTokenizer propertyTokens = new StringTokenizer(properties, ";");
        String property = null;
        while (propertyTokens.hasMoreTokens()) {
            property = this.getDeclaredStringField(propertyTokens.nextToken());
            registeree.addPropertyChangeListener(property, listener);
        }
    }

    private String getDeclaredStringField(String fullyQualifiedField) throws BonsaiConfigException {
        int index = fullyQualifiedField.lastIndexOf(46);
        try {
            return (String)Class.forName(fullyQualifiedField.substring(0, index)).getDeclaredField(fullyQualifiedField.substring(index + 1)).get(null);
        }
        catch (Exception ex) {
            throw new BonsaiConfigException("XML is misconfigured!  Unknown property: " + fullyQualifiedField);
        }
    }

    protected void waitUntilFound(HwmcaParentObject obj) {
        Trace.trace("XBUIDEBT", "-> waitUntilFound(" + obj + ")");
        ShortObjectIdManager idManager = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager();
        UIObjectsReader reader = ControllerServlet.getUIObjectsReader();
        ObjectId objId = obj.getObjectId();
        String shortId = null;
        while (true) {
            if ((shortId = idManager.getShortId(objId)) != null) {
                try {
                    reader.getBuffer(shortId);
                    Trace.trace("XBUIDEBT", "<- waitUntilFound() " + shortId);
                    return;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            try {
                Trace.trace("XBUIDEBT", "going to sleep");
                Thread.sleep(500L);
                Trace.trace("XBUIDEBT", "waking up");
            }
            catch (Exception ex) {
            }
        }
    }
}

